/*
  Create wireframe images with Radiance
  This creates a model with a different surface colour for each primitive
  You should xform expand the radiance file to a suitable level first
*/
#include <stdio.h>

/* #define strcasecmp strcmp	/* uncomment if needed */

int main(argc,argv)
int argc;
char **argv;
{
  FILE *fptr;
  char fname[32];
  char s[100];
  int i,n;
  int r=0,g=0,b=0;

  /* Check the arguments */
  if (argc > 1) {
    strcpy(fname,argv[1]);
    if ((fptr = fopen(fname,"r")) == NULL) {
      fprintf(stderr,"Unable to open Radiance file\n");
      return(0);
    }
  } else {
    fptr = stdin;
  }

  while (fscanf(fptr,"%s",s) == 1)
    if (strcasecmp(s,"sphere") == 0 ||
	strcasecmp(s,"bubble") == 0 ||
	strcasecmp(s,"polygon") == 0 ||
	strcasecmp(s,"cone") == 0 ||
	strcasecmp(s,"cup") == 0 ||
	strcasecmp(s,"cylinder") == 0 ||
	strcasecmp(s,"tube") == 0 ||
	strcasecmp(s,"ring") == 0) {
      
      /* Create a dummy material with a unique colour */
      r = rand() % 100;
      g = rand() % 100;
      b = rand() % 100;
      printf("void glow randmat\n");
      printf("0 0 4 %g %g %g 0\n",r/100.0,g/100.0,b/100.0);

      printf("randmat %s ",s); /* The geometry name */

      fscanf(fptr,"%s\n",s); /* The object name */
      printf("%s ",s);

      fscanf(fptr,"%d",&n); /* First argument line */
      printf("%d ",n);
      for (i=0;i<n;i++) {
	fscanf(fptr,"%s ",s);
	printf("%s ",s);
      }

      fscanf(fptr,"%d",&n); /* Second argument line */
      printf("%d ",n);
      for (i=0;i<n;i++) {
        fscanf(fptr,"%s ",s);
        printf("%s ",s);
      }

      fscanf(fptr,"%d",&n); /* Third argument line */
      printf("%d ",n);
      for (i=0;i<n;i++) {
        fscanf(fptr,"%s ",s);
        printf("%s ",s);
      }
      printf("\n");
    }

  fclose(fptr);
}

