unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Delaunay, StdCtrls;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  TheMesh: TDelaunay;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
TheMesh:= TDelaunay.Create;
TheMesh.TargetForm:=Form1;
Form1.Caption:='Click on the form!';
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
TheMesh.AddPoint(x,y); //add a point to the mesh
TheMesh.Mesh;          //triangulate the mesh
TheMesh.Draw;   //draw the mesh on the forms canvas

Form1.Caption:='Points: '+IntToStr(TheMesh.tPoints-1)+
               '  Triangles: '+IntToStr(TheMesh.HowMany);
end;

end.
